<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}
include 'db.php';

// Pagination variables
$limit = 10; // Limit per page
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$start = ($page - 1) * $limit;

// Search functionality
$searchQuery = '';
if (isset($_POST['search'])) {
    $searchQuery = $_POST['search'];
}

// Sorting functionality
$sortColumn = isset($_GET['sortColumn']) ? $_GET['sortColumn'] : 'id';
$sortOrder = isset($_GET['sortOrder']) ? $_GET['sortOrder'] : 'DESC';

// Modified query to fetch all records but with pagination for display
$query = "SELECT email, firstName, lastName, phone, role, state FROM users WHERE email LIKE '%$searchQuery%' OR firstName LIKE '%$searchQuery%' OR lastName LIKE '%$searchQuery%' ORDER BY $sortColumn $sortOrder LIMIT $start, $limit";
$result = mysqli_query($conn, $query);

// Count total records for pagination (searching across all records)
$totalResult = mysqli_query($conn, "SELECT COUNT(*) AS total FROM users WHERE email LIKE '%$searchQuery%' OR firstName LIKE '%$searchQuery%' OR lastName LIKE '%$searchQuery%'");
$totalRecords = mysqli_fetch_assoc($totalResult)['total'];
$totalPages = ceil($totalRecords / $limit);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <header class="bg-dark text-white text-center py-3">
        <h2>User Transactions</h2>
        <a href="dashboard.php" class="btn btn-secondary btn-sm">Back to Dashboard</a>
    </header>
    <div class="container mt-5">
        <h2 class="text-center">Users List</h2>
        <form method="POST" class="mb-3">
            <input type="text" name="search" value="<?= $searchQuery; ?>" class="form-control" placeholder="Search by email, first name, or last name">
            <button type="submit" class="btn btn-primary mt-2">Search</button>
        </form>
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th><a href="?sortColumn=email&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">Email</a></th>
                    <th><a href="?sortColumn=firstName&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">First Name</a></th>
                    <th><a href="?sortColumn=lastName&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">Last Name</a></th>
                    <th><a href="?sortColumn=phone&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">Phone</a></th>
                    <th><a href="?sortColumn=role&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">Role</a></th>
                    <th><a href="?sortColumn=state&sortOrder=<?= $sortOrder == 'ASC' ? 'DESC' : 'ASC'; ?>">State</a></th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                <tr>
                    <td><?= $row['email']; ?></td>
                    <td><?= $row['firstName']; ?></td>
                    <td><?= $row['lastName']; ?></td>
                    <td><?= $row['phone']; ?></td>
                    <td><?= $row['role']; ?></td>
                    <td><?= $row['state']; ?></td>
                    <td>
                        <a href="user_transactions.php?user=<?= $row['email']; ?>" class="btn btn-info btn-sm">View Transactions</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item <?= $page <= 1 ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?page=<?= $page - 1; ?>&search=<?= $searchQuery; ?>">Previous</a>
                </li>
                <li class="page-item <?= $page >= $totalPages ? 'disabled' : ''; ?>">
                    <a class="page-link" href="?page=<?= $page + 1; ?>&search=<?= $searchQuery; ?>">Next</a>
                </li>
            </ul>
        </nav>
    </div>
    <footer class="bg-dark text-white text-center py-3 mt-5">
        <p>&copy; <?= date('Y'); ?> Admin Panel. All Rights Reserved.</p>
    </footer>
</body>
</html>
